{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnProgressFrm;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣͨý嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עôɳڲƿ͹رգֱӴʵ
*           õԪṩ¼ʾ̬ʾ壺
*             ShowProgress   - ʾ
*             HideProgress   - ؽ
*             UpdateProgress - µǰ
*             UpdateProgressTitle  - ´
* ʹ÷ҪʾʾڵĵԪusesԪҪʾʾϢʱֱ
*           ֱӵShowXXXX̼ɡ
* עͬһʱĻֻʾһȴ壬ʾʱд
*           ʹãʾôĴԿԼС
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַвϱػʽ
* Ԫʶ$Id: CnProgressFrm.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2008.03.08 V1.1
*                xierenxixi ޸÷ʽ
*           2002.04.03 V1.0
*                Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls;

type

{ TProgressForm }

  TProgressForm = class(TForm)
    SpeedButton1: TSpeedButton;
    lblTitle: TLabel;
    ProgressBar: TProgressBar;
    Label1: TLabel;
  private
    { Private declarations }
    FPerLabel: TLabel;
  public
    { Public declarations }
    procedure DoCreate; override;

  end;

procedure ShowProgress(const Title: string; AMax: Integer = 100);
{* ʾ壬ΪԼֵĬ 100ٷֱʽԶֵ}
procedure HideProgress;
{* رս}
procedure UpdateProgress(Value: Integer);
{* µǰȣΪֵ Max Ϊ 100 ʱɽܷΧΪ 0..100ʱ Value ٷֱ}
procedure UpdateProgressTitle(const Title: string);
{* ½⣬Ϊ}
procedure UpdateProgressMax(Value: Integer);
{* ½ֵΪµֵ}

implementation

{$R *.DFM}

var
  ProgressForm: TProgressForm = nil;  // ʵ
  FormList: Pointer;   // õĴбָ

// ʾ
procedure ShowProgress(const Title: string; AMax: Integer = 100);
begin
  if not Assigned(ProgressForm) then
    ProgressForm := TProgressForm.Create(Application.MainForm)
  else
    ProgressForm.BringToFront;
  ProgressForm.lblTitle.Caption := Title;
  ProgressForm.ProgressBar.Max := AMax;
  ProgressForm.Show;

  // xierenxixi ޸
  FormList := DisableTaskWindows(ProgressForm.Handle);
  ProgressForm.Update;
end;

// رմ
procedure HideProgress;
begin
  if not Assigned(ProgressForm) then Exit;

  // xierenxixi ޸
  EnableTaskWindows(FormList);
  
  ProgressForm.Hide;
  Application.ProcessMessages;
  ProgressForm.Free;
  ProgressForm := nil;
end;

// ½
procedure UpdateProgress(Value: Integer);
begin
  if Assigned(ProgressForm) then
  begin
    ProgressForm.ProgressBar.Position := Value;
    ProgressForm.FPerLabel.Caption := Format('%-3d%%', [Round(Value/ProgressForm.ProgressBar.Max * 100)]);
    ProgressForm.Update;
    Application.ProcessMessages;
  end;
end;

// ±
procedure UpdateProgressTitle(const Title: string);
begin
  if Assigned(ProgressForm) then
  begin
    ProgressForm.lblTitle.Caption := Title;
    ProgressForm.Update;
    Application.ProcessMessages;
  end;
end;

// ½ֵ
procedure UpdateProgressMax(Value: Integer);
begin
  if Assigned(ProgressForm) then
  begin
    ProgressForm.ProgressBar.Max:=Value;
    ProgressForm.Update;
    Application.ProcessMessages;
  end;
end;

{ TProgressForm }

procedure TProgressForm.DoCreate;
begin
  inherited;
  FPerLabel := TLabel.Create(Self);
  FPerLabel.Caption := '    '; // 100%
  FPerLabel.Parent := Label1.Parent;
  FPerLabel.Top := Label1.Top;
  FPerLabel.Left := ProgressBar.Left + ProgressBar.Width - FPerLabel.Width;
end;

end.
