{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program PerfectLayout;

{* This Script Shows an Simple Layout Adjustment, similar to GExperts}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
  ClassNameAppBuilder = 'TAppBuilder';
  ClassNameObjectTreeView = 'TObjectTreeView';
  ClassNameObjectInspector = 'TPropertyInspector';
  ClassNameEditWindow = 'TEditWindow';

// Find the First Float(Not Docked) Window by ClassName
function FindFloatWindowbyClassName(const AClassName: string): TCustomForm;
var
  I: Integer;
begin
  Result := nil;
  for I := 0 to Screen.CustomFormCount - 1 do
  begin
    if (Screen.CustomForms[I].Parent = nil) and
      Screen.CustomForms[I].Visible and Screen.CustomForms[I].Floating then
    begin
      if Screen.CustomForms[I].ClassNameIs(AClassName) then
      begin
        Result := Screen.CustomForms[I];
        Exit;
      end;
    end;
  end;
end;

var
  AForm: TCustomForm;
  ATop1, ATop2, AWidth: Integer;
begin
  ATop1 := 0;
  AForm := FindFloatWindowbyClassName(ClassNameAppBuilder);
  if AForm <> nil then
  begin
    // Put Main IDE Window to Top
    AForm.WindowState := wsNormal;
    AForm.Top := 0;
    AForm.Left := 0;
    AForm.Width := Screen.Width - 2;
    ATop1 := ATop1 + AForm.Height;
    ATop2 := ATop1;
  end;

  AWidth := 0;
  AForm := FindFloatWindowbyClassName(ClassNameObjectTreeView);
  if AForm <> nil then
  begin
    // Put Object TreeView Window to Left
    AForm.Top := ATop1;
    AForm.Left := 0;
    ATop2 := ATop2 + AForm.Height;
    AWidth := AForm.Width;
  end;

  AForm := FindFloatWindowbyClassName(ClassNameObjectInspector);
  if AForm <> nil then
  begin
    // Put Object Inspector to Left Bottom
    AForm.Top := ATop2;
    AForm.Left := 0;
    AForm.Height := Screen.Height - ATop2 - 28; // Taskbar
    if AForm.Width > AWidth then
      AWidth := AForm.Width;
  end;

  AForm := FindFloatWindowbyClassName(ClassNameEditWindow);
  if AForm <> nil then
  begin
    // Put EditWindow to Full Right Bottom.
    AForm.WindowState := wsNormal;
    AForm.Top := ATop1;
    AForm.Left := AWidth;
    AForm.Height := Screen.Height - ATop1 - 28; // Taskbar
    AForm.Width := Screen.Width - AWidth;
  end;
end.

