{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnVCLBase;
{* |<PRE>
================================================================================
* ƣ
* Ԫƣඨ嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עõԪĻ
* ƽ̨PWin98SE + Delphi 5.0
* ݲԣPWin9X/2000/XP + Delphi 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id: CnVCLBase.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2002.04.08 V1.0
*               Ԫ°汾
*           2002.02.01 V0.02Demo
*               Դ롢֪
*               ŻCopyParentImageTCnGraphicControlпʾ
*               Alphaָؼ͸ȣˢ£
*               Ӵע
*           2002.01.11 V0.01Demo
*               Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, CnGraphics,
  CnClasses, CnConsts;

type

//------------------------------------------------------------------------------
// ͼοؼ
//------------------------------------------------------------------------------

{ TCnGraphicControl }

  TCnGraphicControl = class(TControl)
  {* CnPackͼοؼ}
  private
    FLoaded: Boolean;
    FUpdateCount: Integer;
    FIsChanged: Boolean;
    FFace: TCnBitmap;
    FTransparent: Boolean;
    FAlphaBlend: Boolean;
    FAlphaBlendValue: TCnAlpha;
    FFullPaint: Boolean;
    FPainting: Boolean;
    FOnMouseLeave: TNotifyEvent;
    FOnMouseEnter: TNotifyEvent;
    FOnPaint: TNotifyEvent;
    procedure WMPaint(var Msg: TWMPaint); message WM_PAINT;
    procedure SetAlphaBlendValue(const Value: TCnAlpha);
    procedure DoPaint;
    procedure DoChanged;
    procedure SetFullPaint(const Value: Boolean);
    procedure SetAlphaBlend(const Value: Boolean);
  protected
    function IsUpdating: Boolean;
    {* ǰ¼Ƿ0ڸ£ֻ}
    procedure WndProc(var Msg: TMessage); override;
    procedure Paint; virtual;
    {* ؼƷؼǰ״̬ıԶø÷
     |<BR> ؼش˷ Face л}
    procedure Loaded; override;
    {* װأڵһPaintʱã
     |<BR> ʱ inherited}
    procedure Changed; virtual;
    {* ѱ޸ĿؼԺø÷֪ͨؼػ棬
     |<BR> ø÷Ҫٵÿؼ Invalidate ȷ
     |<BR> ʱ inherited}
    procedure OnFaceChange(Sender: TObject); virtual;
    procedure OnChildChange(Sender: TObject); virtual;
    {* ѱ֪ͨĬΪChanged}
    procedure MouseEnter; virtual;
    {* ؼ֪ͨأʱ inherited Բ¼}
    procedure MouseLeave; virtual;
    {* Ƴؼ֪ͨأʱ inherited Բ¼}
    procedure SetTransparent(const Value: Boolean); virtual;
    {* ÿؼ͸ԣأʱ inherited}
    property Face: TCnBitmap read FFace;
    {* ؼ滭TCnBitmapͣڴб˿ؼǰͼ
     |<BR> ҪĻϻƿؼʱֱӽλͼƵĻԻÿٵʾ
     |<BR> ؼCanvasԣûֱFaceϻͼҪ
           ĻÿؼRefreshRepaint}
    property AlphaBlend: Boolean read FAlphaBlend write SetAlphaBlend default False;
    {* ؼİ͸ԣΪؼʾΪ͸Ч͸ΪAlphaBlendValue}
    property AlphaBlendValue: TCnAlpha read FAlphaBlendValue write SetAlphaBlendValue
      default csMaxAlpha;
    {* ؼĲ͸ԣAlphaBlendӰ죬Ϊ0ʱȫ͸255ʱ͸}
    property Transparent: Boolean read FTransparent write SetTransparent default False;
    {* ؼı͸ԣΪؼʾΪ״͸}
    property FullPaint: Boolean read FFullPaint write SetFullPaint default True;
    {* TransparentʱǷÿػؼƿؼ
    |<BR> ؼĿؼ͸ؼΪ̬ʱرոԿʾٶ
    |<BR> ؼĿؼ͸ؼΪ̬ʱΪ}
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    {* ؼ¼}
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    {* Ƴؼ¼}
    property OnPaint: TNotifyEvent read FOnPaint write FOnPaint;
    {* ؼػ¼}
  public
    constructor Create(AOwner: TComponent); override;
    {* һؼʵ}
    destructor Destroy; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    {* ÿؼλúʹС}
    procedure BeginUpdate;
    {* ʼ¿ؼ¹пؼػ棬
     |<BR> ڶԳԽ޸ʱø÷עEndUpdateɶʹ}
    procedure EndUpdate;
    {* £ǰ¼Ϊ0ԶChange
     |<BR> ڶԳ޸ĺø÷עBeginUpdateɶʹ}
    procedure Repaint; override;
    {* ǿȿؼĻϻƣֶ޸ Face ԣô˷}
    procedure ReDraw; virtual;
    {* ǿȿؼ»Ļ}
  end;

//------------------------------------------------------------------------------
// ڿؼ
//------------------------------------------------------------------------------

{ TCnWinControl }

  TCnWinControl = class(TWinControl)
  private
    FLoaded: Boolean;
    FUpdateCount: Integer;
    FIsChanged: Boolean;
    FFace: TCnBitmap;
    FTransparent: Boolean;
    FAlphaBlendValue: TCnAlpha;
    FFullPaint: Boolean;
    FOnMouseLeave: TNotifyEvent;
    FOnMouseEnter: TNotifyEvent;
    FAlphaBlend: Boolean;
    procedure WMPaint(var Msg: TWMPaint); message WM_PAINT;
    procedure SetAlphaBlendValue(const Value: TCnAlpha);
    procedure DoPaint;
    procedure DoChanged;
    procedure SetFullPaint(const Value: Boolean);
    procedure SetAlphaBlend(const Value: Boolean);
  protected
    function IsUpdating: Boolean;
    procedure WndProc(var Msg: TMessage); override;
    procedure Paint; virtual;
    procedure Loaded; override;
    procedure Changed; virtual;
    procedure OnFaceChange(Sender: TObject); virtual;
    procedure OnChildChange(Sender: TObject); virtual;
    procedure MouseEnter; virtual;
    procedure MouseLeave; virtual;
    procedure SetTransparent(const Value: Boolean); virtual;
    procedure PaintControls(Bmp: TCnBitmap; First: TControl);
    procedure PaintHandler(var message: TWMPaint);
    property Face: TCnBitmap read FFace;
    property AlphaBlend: Boolean read FAlphaBlend write SetAlphaBlend default False;
    property AlphaBlendValue: TCnAlpha read FAlphaBlendValue write SetAlphaBlendValue
      default csMaxAlpha;
    property Transparent: Boolean read FTransparent write SetTransparent default False;
    property FullPaint: Boolean read FFullPaint write SetFullPaint default True;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure BeginUpdate;
    procedure EndUpdate;
    procedure Repaint; override;
  end;

implementation

type
  TParentControl = class(TWinControl);
  TCnPersistentAccess = class(TCnPersistent);
  TCnFontAccess = class(TCnFont);

// Ӹؼͼ
// ޸RxLibrary VCLUtils
procedure CopyParentImage(Control: TControl; Bmp: TCnBitmap);
var
  I, Count, x, y, SaveIndex: Integer;
  r, SelfR, CtlR: TRect;
  Parent: TWinControl;
  // CnParent: TCnWinControl;
begin
  if (Control = nil) or (Control.Parent = nil) then Exit;
  Count := Control.Parent.ControlCount;
  Parent := Control.Parent;
  {if Control.Parent is TCnWinControl then
  begin
    CnParent := TCnWinControl(Control.Parent);
    Bmp.DrawEx(0, 0, CnParent.Face, Control.ClientRect);
  end;}
  with Parent do
    ControlState := ControlState + [csPaintCopy];
  try
    with Control do
    begin
      SelfR := Bounds(Left, Top, Width, Height);
      x := -Left;
      y := -Top;
    end;
    // Ƹؼͼ
    SaveIndex := SaveDC(Bmp.DC);
    try
      SetViewportOrgEx(Bmp.DC, x, y, nil);
      IntersectClipRect(Bmp.DC, 0, 0, Parent.ClientWidth,
        Parent.ClientHeight);
      try
        with TParentControl(Parent) do
        begin
          Perform(WM_ERASEBKGND, Bmp.DC, 0);
          PaintWindow(Bmp.DC);
        end;
      except
        ;
      end;
    finally
      RestoreDC(Bmp.DC, SaveIndex);
    end;
    // ͼοؼͼ
    for I := 0 to Count - 1 do //  Z-Order ˳
    begin
      if Parent.Controls[I] = Control then // ֻںĿؼ
        Break
      else if (Parent.Controls[I] <> nil) then
      begin
        if (Parent.Controls[I] is TCnGraphicControl) then
          with TCnGraphicControl(Parent.Controls[I]) do
          begin               // TCnGraphicControl ؼֱӴ Face иƣ٣
            CtlR := Bounds(Left, Top, Width, Height);
            if IntersectRect(r, SelfR, CtlR) and (Visible or (csDesigning in
              ComponentState)) then // Χཻ
              Bmp.AlphaDraw(Left - Control.Left, Top - Control.Top, Face, ClientRect,
                AlphaBlendValue);
          end
        else if not (Parent.Controls[I] is TWinControl) then // ͼοؼ
          with Parent.Controls[I] do
          begin
            CtlR := Bounds(Left, Top, Width, Height);
            if IntersectRect(r, SelfR, CtlR) and (Visible or (csDesigning in
              ComponentState)) then
            begin
              ControlState := ControlState + [csPaintCopy];
              SaveIndex := SaveDC(Bmp.DC);
              try
                SaveIndex := SaveDC(Bmp.DC);
                SetViewportOrgEx(Bmp.DC, Left + x, Top + y, nil);
                IntersectClipRect(Bmp.DC, 0, 0, Width, Height);
                Perform(WM_PAINT, Bmp.DC, 0); // ǿƿؼƵĿDC
              finally
                RestoreDC(Bmp.DC, SaveIndex);
                ControlState := ControlState - [csPaintCopy];
              end;
            end;
          end;
      end;
    end;
  finally
    with Parent do
      ControlState := ControlState - [csPaintCopy];
  end;
end;

//------------------------------------------------------------------------------
// ͼοؼ
//------------------------------------------------------------------------------

{ TCnGraphicControl }

// ʼ
constructor TCnGraphicControl.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle + [csOpaque]; // ֹˢʱ
  FUpdateCount := 0;
  FLoaded := False;
  FFace := TCnBitmap.Create(OnFaceChange);
  FFace.Transparent := False;
  FFace.GdiAllocStyle := gsNormal;
  TCnFontAccess(FFace.Font).Owner := Self;
  TCnPersistentAccess(FFace.Font.Gradient).Owner := FFace.Font;
  FTransparent := False;
  FFullPaint := True;
  FAlphaBlend := False;
  FAlphaBlendValue := csMaxAlpha; // ͸
  FPainting := False;
end;

// ͷ
destructor TCnGraphicControl.Destroy;
begin
  FFace.Free;
  inherited;
end;

//--------------------------------------------------------//
// صķ                                           //
//--------------------------------------------------------//

// װأڵһPaintʱã
// ʱ inherited
procedure TCnGraphicControl.Loaded;
begin
  inherited;
  FLoaded := True;
  Changed;
end;

// ѱ
procedure TCnGraphicControl.Changed;
begin
  if IsUpdating then
    FIsChanged := True
  else
    DoChanged;
end;

// ؼƷ
// ؼڸùж Face л
procedure TCnGraphicControl.Paint;
begin

end;

// 
procedure TCnGraphicControl.MouseEnter;
begin
  if Assigned(FOnMouseEnter) then
    FOnMouseEnter(Self);
end;

// Ƴ
procedure TCnGraphicControl.MouseLeave;
begin
  if Assigned(FOnMouseLeave) then
    FOnMouseLeave(Self);
end;

// ݱ
procedure TCnGraphicControl.OnFaceChange(Sender: TObject);
begin
  //
end;

// Ա
procedure TCnGraphicControl.OnChildChange(Sender: TObject);
begin
  Changed;
end;

//--------------------------------------------------------//
// ܷ                                           //
//--------------------------------------------------------//

// ʼ£ڼ䲻ˢʾ
procedure TCnGraphicControl.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

// 
procedure TCnGraphicControl.EndUpdate;
begin
  Assert(FUpdateCount > 0, 'Unpaired TCnGraphicControl.EndUpdate');
  Dec(FUpdateCount);

  if not IsUpdating and FIsChanged then // ѱ
    DoChanged;
end;

// ڸ
function TCnGraphicControl.IsUpdating: Boolean;
begin
  Result := FUpdateCount > 0;
end;

// ѱˢ¿ؼ
procedure TCnGraphicControl.DoChanged;
begin
  FIsChanged := False;
  DoPaint;
  Invalidate;
end;

// ˢ¿ؼʾ
procedure TCnGraphicControl.DoPaint;
begin
  if not FPainting then
  begin
    FPainting := True;
    if FTransparent then
      CopyParentImage(Self, Face) // ͸ȸƸؼͼ
    else
      Face.Fill(Color);       // ͸Color
    Paint;                    // ⷽPaintƿؼ
    FPainting := False;
  end;
end;

// ؼˢʾ
procedure TCnGraphicControl.Repaint;
begin
  inherited;
  { TODO -oܾ -cͼοؼ : ؼػ淽 }
end;

// ؼ»ƻ
procedure TCnGraphicControl.ReDraw;
begin
  Changed;
end;

// ؼػϢ
procedure TCnGraphicControl.WMPaint(var Msg: TWMPaint);
var
  Bmp: TCnBitmap;
begin
  if (csDesigning in ComponentState) and not FLoaded then
  begin
    FLoaded := True;          // ڵһػ Loaded 
    Loaded;
  end;

  if AlphaBlend and (AlphaBlendValue = 0) then Exit; // ȫ͸

  if FTransparent and FFullPaint then
    DoPaint;                  // ͸ˢʱÿػ涼

  if not AlphaBlend or (AlphaBlendValue = csMaxAlpha) then // ް͸Ч
  begin
    if Msg.DC <> 0 then
    begin
      Face.Lock;
      try
        Face.DrawTo(Msg.DC, 0, 0); // ƵĿDC
      finally
        Face.Unlock;
      end;
    end;
  end
  else
  begin                       // ͸Ч
    Bmp := TCnBitmap.Create;
    try
      Bmp.LoadBlank(Width, Height);
      CopyParentImage(Self, Bmp); // Ӹؼͼ
      Bmp.AlphaDraw(Face, AlphaBlendValue, False); // Alpha
      Bmp.DrawTo(Msg.DC, 0, 0); // ƵĿDC
    finally
      Bmp.Free;
    end;
  end;
end;

// Ϣ
procedure TCnGraphicControl.WndProc(var Msg: TMessage);
begin
  case Msg.Msg of
    CM_COLORCHANGED, CM_TEXTCHANGED, CM_FONTCHANGED: Changed;
    CM_MOUSEENTER: MouseEnter; // 
    CM_MOUSELEAVE: MouseLeave; // Ƴ
  end;
  inherited;
end;

// ÿؼ߽
procedure TCnGraphicControl.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  inherited;
  if (Face.Width <> Width) or (Face.Height <> Height) then
  begin
    Face.LoadBlank(Width, Height); // ޸Ļߴ
    Changed;
  end;
end;

// ͸
procedure TCnGraphicControl.SetTransparent(const Value: Boolean);
begin
  if FTransparent <> Value then
  begin
    FTransparent := Value;
    Changed;
  end;
end;

// ò͸
procedure TCnGraphicControl.SetAlphaBlendValue(const Value: TCnAlpha);
begin
  if FAlphaBlendValue <> Value then
  begin
    FAlphaBlendValue := Value;
    Changed;
  end;
end;

// ò͸֧
procedure TCnGraphicControl.SetAlphaBlend(const Value: Boolean);
begin
  if FAlphaBlend <> Value then
  begin
    FAlphaBlend := Value;
    Changed;
  end;
end;

// ͸ʱػ
procedure TCnGraphicControl.SetFullPaint(const Value: Boolean);
begin
  if FFullPaint <> Value then
  begin
    FFullPaint := Value;
    Changed;
  end;
end;

//------------------------------------------------------------------------------
// ڿؼ
//------------------------------------------------------------------------------

{ TCnWinControl }

// ʼ
constructor TCnWinControl.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle + [csOpaque]; // ֹˢʱ
  FUpdateCount := 0;
  FLoaded := False;
  FFace := TCnBitmap.Create(OnFaceChange);
  FFace.Transparent := False;
  FFace.GdiAllocStyle := gsNormal;
  FTransparent := False;
  FFullPaint := True;
  FAlphaBlend := False;
  FAlphaBlendValue := csMaxAlpha; // ͸
end;

// ͷ
destructor TCnWinControl.Destroy;
begin
  FFace.Free;
  inherited;
end;

//--------------------------------------------------------//
// صķ                                           //
//--------------------------------------------------------//

// װأڵһPaintʱã
// ʱ inherited
procedure TCnWinControl.Loaded;
begin
  inherited;
  FLoaded := True;
  Changed;
end;

// ѱ
procedure TCnWinControl.Changed;
begin
  if IsUpdating then
    FIsChanged := True
  else
    DoChanged;
end;

// ؼƷ
// ؼڸùж Face л
procedure TCnWinControl.Paint;
begin

end;

// 
procedure TCnWinControl.MouseEnter;
begin
  if Assigned(FOnMouseEnter) then
    FOnMouseEnter(Self);
end;

// Ƴ
procedure TCnWinControl.MouseLeave;
begin
  if Assigned(FOnMouseLeave) then
    FOnMouseLeave(Self);
end;

// ݱ
procedure TCnWinControl.OnFaceChange(Sender: TObject);
begin
  //
end;

// Ա
procedure TCnWinControl.OnChildChange(Sender: TObject);
begin
  Changed;
end;

//--------------------------------------------------------//
// ܷ                                           //
//--------------------------------------------------------//

// ʼ£ڼ䲻ˢʾ
procedure TCnWinControl.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

// 
procedure TCnWinControl.EndUpdate;
begin
  Assert(FUpdateCount > 0, 'Unpaired TCnWinControl.EndUpdate');
  Dec(FUpdateCount);

  if not IsUpdating and FIsChanged then // ѱ
    DoChanged;
end;

// ڸ
function TCnWinControl.IsUpdating: Boolean;
begin
  Result := FUpdateCount > 0;
end;

// ѱˢ¿ؼ
procedure TCnWinControl.DoChanged;
begin
  FIsChanged := False;
  DoPaint;
  Invalidate;
end;

// ˢ¿ؼʾ
procedure TCnWinControl.DoPaint;
begin
  if FTransparent then
    CopyParentImage(Self, Face) // ͸ȸƸؼͼ
  else
    Face.Fill(Color);         // ͸Color
  Paint;                      // ⷽPaintƿؼ
end;

// ؼػ淽
procedure TCnWinControl.Repaint;
begin
  inherited;
  { TODO -oܾ -cͼοؼ : ؼػ淽 }
end;

// ؼػϢ
procedure TCnWinControl.WMPaint(var Msg: TWMPaint);
var
  Bmp: TCnBitmap;
begin
  if (csDesigning in ComponentState) and not FLoaded then
  begin
    FLoaded := True;          // ڵһػ Loaded 
    Loaded;
  end;

  if AlphaBlend and (AlphaBlendValue = 0) then Exit; // ȫ͸

  if FTransparent and FFullPaint then
    DoPaint;                  // ͸ˢʱÿػ涼

  if not AlphaBlend or (AlphaBlendValue = csMaxAlpha) then // ް͸Ч
  begin
    if Msg.DC <> 0 then
    begin
      Face.Lock;
      try
        Face.DrawTo(Msg.DC, 0, 0); // ƵĿDC
      finally
        Face.Unlock;
      end;
    end;
  end
  else
  begin                       // ͸Ч
    Bmp := TCnBitmap.Create;
    try
      Bmp.LoadBlank(Width, Height);
      CopyParentImage(Self, Bmp); // Ӹؼͼ
      Bmp.AlphaDraw(Face, AlphaBlendValue, False); // Alpha
      Bmp.DrawTo(Msg.DC, 0, 0); // ƵĿDC
    finally
      Bmp.Free;
    end;
  end;
end;

// Ϣ
procedure TCnWinControl.WndProc(var Msg: TMessage);
begin
  case Msg.Msg of
    CM_COLORCHANGED, CM_TEXTCHANGED, CM_FONTCHANGED: Changed;
    CM_MOUSEENTER: MouseEnter; // 
    CM_MOUSELEAVE: MouseLeave; // Ƴ
  end;
  inherited;
end;

// ÿؼ߽
procedure TCnWinControl.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  inherited;
  if (Face.Width <> Width) or (Face.Height <> Height) then
  begin
    Face.LoadBlank(Width, Height); // ޸Ļ
    Changed;
  end;
end;

// ͸
procedure TCnWinControl.SetTransparent(const Value: Boolean);
begin
  if FTransparent <> Value then
  begin
    FTransparent := Value;
    Changed;
  end;
end;

// ò͸
procedure TCnWinControl.SetAlphaBlendValue(const Value: TCnAlpha);
begin
  if FAlphaBlendValue <> Value then
  begin
    FAlphaBlendValue := Value;
    Changed;
  end;
end;

// ò͸֧
procedure TCnWinControl.SetAlphaBlend(const Value: Boolean);
begin
  if FAlphaBlend <> Value then
  begin
    FAlphaBlend := Value;
    Changed;
  end;
end;

// ͸ʱػ
procedure TCnWinControl.SetFullPaint(const Value: Boolean);
begin
  if FFullPaint <> Value then
  begin
    FFullPaint := Value;
    Changed;
  end;
end;

procedure TCnWinControl.PaintControls(Bmp: TCnBitmap; First: TControl);
//var
  //I, Count, SaveIndex: Integer;
  //FrameBrush: HBRUSH;
begin
  {if FControls <> nil then
  begin
    I := 0;
    if First <> nil then
    begin
      I := FControls.IndexOf(First);
      if I < 0 then I := 0;
    end;
    Count := FControls.Count;
    while I < Count do
    begin
      with TControl(FControls[I]) do
        if (Visible or (csDesigning in ComponentState) and
          not (csNoDesignVisible in ControlStyle)) and
          RectVisible(DC, Rect(Left, Top, Left + Width, Top + Height)) then
        begin
          if csPaintCopy in Self.ControlState then
            Include(FControlState, csPaintCopy);
          SaveIndex := SaveDC(DC);
          MoveWindowOrg(DC, Left, Top);
          IntersectClipRect(DC, 0, 0, Width, Height);
          Perform(WM_PAINT, DC, 0);
          RestoreDC(DC, SaveIndex);
          Exclude(FControlState, csPaintCopy);
        end;
      Inc(I);
    end;
  end;
  if FWinControls <> nil then
    for I := 0 to FWinControls.Count - 1 do
      with TWinControl(FWinControls[I]) do
        if FCtl3D and (csFramed in ControlStyle) and
          (Visible or (csDesigning in ComponentState) and
          not (csNoDesignVisible in ControlStyle)) then
        begin
          FrameBrush := CreateSolidBrush(ColorToRGB(clBtnShadow));
          FrameRect(DC, Rect(Left - 1, Top - 1, Left + Width, Top + Height),
            FrameBrush);
          DeleteObject(FrameBrush);
          FrameBrush := CreateSolidBrush(ColorToRGB(clBtnHighlight));
          FrameRect(DC, Rect(Left, Top, Left + Width + 1, Top + Height + 1),
            FrameBrush);
          DeleteObject(FrameBrush);
        end;}
end;

procedure TCnWinControl.PaintHandler(var message: TWMPaint);
begin

end;

end.

