{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnWizHelperIntf;

interface
{ |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣCnWizHelper.dll Ľӿ
* Ԫߣܾ (zjy@cnpack.org)
*     ע
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id: CnWizInetUtils.pas 418 2010-02-08 04:53:54Z zhoujingyu $
* ޸ļ¼2010.05.1 V1.0 by zjy
*               Ԫ
================================================================================
|</PRE>}

uses
  Windows, SysUtils, CnCommon;

const
  SCnWizHelperDllName = 'CnWizHelper.Dll';

function CnWizHelperLoaded: Boolean;

//------------------------------------------------------------------------------
// ZIP 
//------------------------------------------------------------------------------

function CnWizHelperZipValid: Boolean;

procedure CnWiz_StartZip(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
  RemovePath: Boolean); stdcall;
{* ʼһ Zipڲָļ}

procedure CnWiz_ZipAddFile(FileName: PAnsiChar); stdcall;
{* ļ Zip}

function CnWiz_ZipSaveAndClose: Boolean; stdcall;
{* ѹ Zip ļͷڲ}

//------------------------------------------------------------------------------
// InetUtils 
//------------------------------------------------------------------------------

function CnWizHelperInetValid: Boolean;

function CnWiz_Inet_GetFile(AURL, FileName: PAnsiChar): Boolean; stdcall;

implementation

{$IFDEF DEBUG}
uses
  CnDebug;
{$ENDIF}

type
  TProcCnWiz_StartZip = procedure (const SaveFileName: PAnsiChar; const Password: PAnsiChar;
    RemovePath: Boolean); stdcall;
  {* ʼһ Zipڲָļ}

  TProcCnWiz_ZipAddFile = procedure (FileName: PAnsiChar); stdcall;
  {* ļ Zip}

  TFuncCnWiz_ZipSaveAndClose = function : Boolean; stdcall;
  {* ѹ Zip ļͷڲ}

  TFuncCnWiz_Inet_GetFile = function (AURL, FileName: PAnsiChar): Boolean; stdcall;

var
  hHelperDll: HMODULE;

  fnCnWiz_StartZip: TProcCnWiz_StartZip;
  fnCnWiz_ZipAddFile: TProcCnWiz_ZipAddFile;
  fnCnWiz_ZipSaveAndClose: TFuncCnWiz_ZipSaveAndClose;
  fnCnWiz_Inet_GetFile: TFuncCnWiz_Inet_GetFile;

procedure LoadWizHelperDll;
var
  ModuleName: array[0..MAX_Path - 1] of Char;
begin
  GetModuleFileName(hInstance, ModuleName, MAX_PATH);
  hHelperDll := LoadLibrary(PChar(_CnExtractFilePath(ModuleName) + SCnWizHelperDllName));
  
  if hHelperDll <> 0 then
  begin
    fnCnWiz_StartZip := TProcCnWiz_StartZip(GetProcAddress(hHelperDll, 'CnWiz_StartZip'));
    fnCnWiz_ZipAddFile := TProcCnWiz_ZipAddFile(GetProcAddress(hHelperDll, 'CnWiz_ZipAddFile'));
    fnCnWiz_ZipSaveAndClose := TFuncCnWiz_ZipSaveAndClose(GetProcAddress(hHelperDll, 'CnWiz_ZipSaveAndClose'));
    fnCnWiz_Inet_GetFile := TFuncCnWiz_Inet_GetFile(GetProcAddress(hHelperDll, 'CnWiz_Inet_GetFile'));
  end
  else
  begin
  {$IFDEF DEBUG}
    CnDebugger.LogMsg('Load CnWizHelper.dll failed.');
  {$ENDIF}
  end;

{$IFDEF DEBUG}
  CnDebugger.LogBoolean(CnWizHelperZipValid, 'CnWizHelperZipValid');
  CnDebugger.LogBoolean(CnWizHelperInetValid, 'CnWizHelperInetValid');
{$ENDIF}
end;

procedure FreeWizHelperDll;
begin
  if hHelperDll <> 0 then
  begin
    FreeLibrary(hHelperDll);
    hHelperDll := 0;
  end;
end;  

function CnWizHelperLoaded: Boolean;
begin
  Result := hHelperDll <> 0;
end;  

//------------------------------------------------------------------------------
// ZIP 
//------------------------------------------------------------------------------

function CnWizHelperZipValid: Boolean;
begin
  Result := CnWizHelperLoaded and Assigned(fnCnWiz_StartZip) and
    Assigned(fnCnWiz_ZipAddFile) and Assigned(fnCnWiz_ZipSaveAndClose);
end;  

procedure CnWiz_StartZip(const SaveFileName: PAnsiChar; const Password: PAnsiChar;
  RemovePath: Boolean); stdcall;
begin
  if CnWizHelperZipValid then
    fnCnWiz_StartZip(SaveFileName, Password, RemovePath);
end;  

procedure CnWiz_ZipAddFile(FileName: PAnsiChar); stdcall;
begin
  if CnWizHelperZipValid then
    fnCnWiz_ZipAddFile(FileName);
end;

function CnWiz_ZipSaveAndClose: Boolean; stdcall;
begin
  if CnWizHelperZipValid then
    Result := fnCnWiz_ZipSaveAndClose
  else
    Result := False;
end;

//------------------------------------------------------------------------------
// InetUtils 
//------------------------------------------------------------------------------

function CnWizHelperInetValid: Boolean;
begin
  Result := CnWizHelperLoaded and Assigned(fnCnWiz_Inet_GetFile);
end;

function CnWiz_Inet_GetFile(AURL, FileName: PAnsiChar): Boolean; stdcall;
begin
  if CnWizHelperInetValid then
    Result := fnCnWiz_Inet_GetFile(AURL, FileName)
  else
    Result := False;
end;  

initialization
  LoadWizHelperDll;

finalization
  FreeWizHelperDll;

end.
