{*******************************************************}
{                                                       }
{       Pascal Script Source File                       }
{       Run by RemObjects Pascal Script in CnWizards    }
{                                                       }
{       Generated by CnPack IDE Wizards                 }
{                                                       }
{*******************************************************}

program WorkTime;

// Liu Xiao: It can show a Form to do Design/Code/Other Time Statistics
// during Development. Debugging Time does NOT Support.

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
  SCnWorkTimeFormName = 'CnWorkTimeForm';
  SCnTimeFormat = '%d Days %d Hours %d Minutes %d Seconds';

var
  Comp: TComponent;
  Form: TForm;
  LblDesign, LblCode, LblOther: TLabel;
  BtnStart, BtnStop, BtnClose: TButton;
  Timer: TTimer;

  DesignTime, CodeTime, OtherTime: Integer;

procedure BtnStartClick(Sender: TObject);
begin
  Timer.Enabled := True;
  BtnStart.Enabled := False;
  BtnStop.Enabled := True;
end;

procedure BtnStopClick(Sender: TObject);
begin
  Timer.Enabled := False;
  BtnStart.Enabled := True;
  BtnStop.Enabled := False;
end;

procedure BtnCloseClick(Sender: TObject);
begin
  Form.Close;
end;

procedure FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  // You also can do nothing here and just Hide it and Do the Statistics in Background.
end;

function FormatStatisticTime(ASec: Integer): string;
var
  Day, Hour, Mini, Sec, MSec: Word;
begin
  Day := ASec div 86400;
  DecodeTime(ASec / 86400.0, Hour, Mini, Sec, MSec);
  Result := Format(SCnTimeFormat, [Day, Hour, Mini, Sec]);
end;

procedure TimerOnTimer(Sender: TObject);
begin
  if CurrentIsSource then
    CodeTime := CodeTime + 1
  else if (IdeGetDesignedForm(nil) <> nil) and
    ((Screen.ActiveCustomForm = nil) or (not (fsModal in Screen.ActiveCustomForm.FormState))) then
    DesignTime := DesignTime + 1
  else
    OtherTime := OtherTime + 1;

  LblDesign.Caption := 'Design Time: ' + FormatStatisticTime(DesignTime);
  LblCode.Caption := 'Coding Time: ' + FormatStatisticTime(CodeTime);
  LblOther.Caption := 'Others Time: ' + FormatStatisticTime(OtherTime);
end;

function CreateLabel(Parent: TWinControl; Name: string; Left, Top: Integer;
  Caption: string): TLabel;
begin
  Result := TLabel.Create(Parent);
  Result.Name := Name;
  Result.Parent := Parent;
  Result.Left := Left;
  Result.Top := Top;
  Result.Caption := Caption;
end;

function CreateButton(Parent: TWinControl; Name: string; Left, Top: Integer;
  Caption: string): TButton;
begin
  Result := TButton.Create(Parent);
  Result.Name := Name;
  Result.Parent := Parent;
  Result.Left := Left;
  Result.Top := Top;
  Result.Caption := Caption;
end;

begin
  Comp := Application.FindComponent(SCnWorkTimeFormName);
  if (Comp <> nil) and (Comp is TForm) then
  begin
    Form := TForm(Comp);
    Form.Show;
    Form.BringToFront;
    Form.SetFocus;
    Exit;
  end;

  DesignTime := 0;
  CodeTime := 0;
  OtherTime := 0;

  Form := TForm.Create(Application);
  Form.Name := SCnWorkTimeFormName;
  Form.Width := 280;
  Form.Height := 130;
  Form.Caption := 'Working Time Statistics';
  Form.Top := Application.MainForm.Top + Application.MainForm.Height + 2;
  Form.Left := Screen.Width - Form.Width - 2;

  Form.OnClose := @FormClose;
  LblDesign := CreateLabel(Form, 'lblDesign', 8, 8, 'Design Time: ');
  LblCode := CreateLabel(Form, 'lblCode', 8, 28, 'Coding Time: ');
  LblOther := CreateLabel(Form, 'lblOther', 8, 48, 'Others Time: ');

  BtnStart := CreateButton(Form, 'btnStart', 8, 75, 'Start');
  BtnStop := CreateButton(Form, 'btnStop', 8 + 90, 75, 'Stop');
  BtnClose := CreateButton(Form, 'btnClose', 8 + 90 * 2, 75, 'Close');

  BtnStart.Height := 21;
  BtnStop.Height := 21;
  BtnClose.Height := 21;
  BtnStop.Enabled := False;

  BtnStart.OnClick := @BtnStartClick;
  BtnStop.OnClick := @BtnStopClick;
  BtnClose.OnClick := @BtnCloseClick;

  Timer := TTimer.Create(Form);
  Timer.Enabled := False;
  Timer.OnTimer := @TimerOnTimer;
  
  Form.Show;
end.

