{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2012 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnImageProvider_IconFinder;
{* |<PRE>
================================================================================
* ƣԡ༭
* Ԫƣwww.IconFinder.com ֵ֧Ԫ
* Ԫߣܾ zjy@cnpack.org
*     ע
* ƽ̨Win7 + Delphi 7
* ݲԣ
*   õԪʹеַѾػʽ
* Ԫʶ$Id: CnImageProvider_IconFinder.pas 1146 2012-10-24 06:25:41Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2011.07.04 V1.0
*               Ԫ
================================================================================
|</PRE>}

{$I CnWizards.inc}

interface

{$DEFINE USE_MSXML}

uses
  Windows, SysUtils, Classes, Graphics, CnImageProviderMgr, CnInetUtils,
{$IFDEF CN_USE_MSXML}
  ActiveX, ComObj, msxml,
{$ELSE}
  OmniXML, OmniXMLUtils,
{$ENDIF}
  CnCommon, CnWizXmlUtils;

type
  TCnImageProvider_IconFinder = class(TCnBaseImageProvider)
  protected
    function DoSearchImage(Req: TCnImageReqInfo): Boolean; override;
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure GetProviderInfo(var DispName, HomeUrl: string); override;
    procedure OpenInBrowser(Item: TCnImageRespItem); override;
    function SearchIconset(Item: TCnImageRespItem; var Req: TCnImageReqInfo): Boolean; override;
  end;
  
implementation

{ TCnImageProvider_IconFinder }

constructor TCnImageProvider_IconFinder.Create;
begin
  inherited;
  FItemsPerPage := 20;
  FFeatures := [pfOpenInBrowser, pfSearchIconset];
end;

destructor TCnImageProvider_IconFinder.Destroy;
begin

  inherited;
end;

class procedure TCnImageProvider_IconFinder.GetProviderInfo(var DispName,
  HomeUrl: string);
begin
  DispName := 'IconFinder.com';
  HomeUrl := 'http://www.iconfinder.com';
end;

function TCnImageProvider_IconFinder.DoSearchImage(Req: TCnImageReqInfo): Boolean;
var
  Url, Text: string;
  Lic: Integer;
  xml: IXMLDocument;
  root, node, icon: IXMLNode;
  i, j, size: Integer;
  Item: TCnImageRespItem;
begin
  Result := False;
  if Req.CommercialLicenses then
    Lic := 1
  else
    Lic := 0;
  Url := Format('http://www.iconfinder.com/xml/search/?q=%s&c=%d&p=%d&l=%d&min=%d&max=%d&api_key=7cb3bc9947285bc4b3a2f2d8bd20a3dd',
    [Req.Keyword, FItemsPerPage, Req.Page, Lic, Req.MinSize, Req.MaxSize]);
  Text := string(CnInet_GetString(Url));
  xml := CreateXMLDoc;
  if xml.LoadXML(Text) then
  begin
    root := FindNode(xml, 'results');
    if root <> nil then
    begin
      for i := 0 to root.ChildNodes.Length - 1 do
      begin
        node := root.ChildNodes.Item[i];
        if SameText(node.NodeName, 'opensearch:totalResults') then
        begin
          FTotalCount := XMLStrToIntDef(node.Text, 0);
          FPageCount := (FTotalCount + FItemsPerPage - 1) div FItemsPerPage;
        end
        else if SameText(node.NodeName, 'iconmatches') then
        begin
          Result := True;
          for j := 0 to node.ChildNodes.Length - 1 do
          begin
            icon := node.ChildNodes.Item[j];
            if SameText(icon.NodeName, 'icon') then
            begin
              size := GetNodeTextInt(icon, 'size', 0);
              if (size >= Req.MinSize) and (size <= Req.MaxSize) then
              begin
                Item := Items.Add;
                Item.Size := size;
                Item.Id := GetNodeTextStr(icon, 'id', '');
                Item.Url := GetNodeTextStr(icon, 'image', '');
                Item.Ext := _CnExtractFileExt(Item.Url);
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure TCnImageProvider_IconFinder.OpenInBrowser(Item: TCnImageRespItem);
begin
  OpenUrl(Format('http://www.iconfinder.com/icondetails/%s/%d/', [Item.Id, Item.Size]));
end;

function TCnImageProvider_IconFinder.SearchIconset(Item: TCnImageRespItem;
  var Req: TCnImageReqInfo): Boolean;
var
  Url, Text: string;
  xml: IXMLDocument;
  root, node: IXMLNode;
begin
  Result := False;
  Url := Format('http://www.iconfinder.com/xml/icondetails/?id=%s&size=%d&api_key=7cb3bc9947285bc4b3a2f2d8bd20a3dd',
    [Item.Id, Item.Size]);
  Text := string(CnInet_GetString(Url));
  xml := CreateXMLDoc;
  if xml.LoadXML(Text) then
  begin
    root := FindNode(xml, 'icon');
    if root <> nil then
    begin
      node := FindNode(root, 'iconsetid');
      if node <> nil then
      begin
        Req.Keyword := 'iconset:' + node.Text;
        Req.Page := 0;
        Result := True;
      end;
    end;
  end;
end;

initialization
  ImageProviderMgr.RegisterProvider(TCnImageProvider_IconFinder);

end.
