{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

unit CnIocpSimpleMemPool;
{* |<PRE>
================================================================================
* ƣͨѶ
* ԪƣWindowsɶ˿(IOCP)ʹõļڴʵֵԪ
* Ԫߣcnwinds
*           (cxmld@126.com) ֲ޸
*     ע
*   1.TCnMemPoolMgrڴعʵ֡
*     CnMemPoolMgrTCnMemPoolMgrȫֶ󣬿ͨöʹڴء
*     С(MemorySize)ͬڴ(TCnMemoryBlockItem)һ(TCnMemoryTypeItem)нй
*     TCnMemPoolMgrйڴͿ(TCnMemoryTypeItem)
*     һڴͿ(TCnMemoryTypeItem)а˶ڴ(TCnMemoryBlockItem)
*     ֵ(Threshold)һTMemoryTypeItemڴĸ
*       ϵͳƵڴʱܸڷֵ
*       ϵͳڴĲʹڷֵʱͷڴ飬ܸڷֵ
*       ԿԱⷱæʱƵ롢ͷڴ棬߿еʱ˷ڴ档
*   2.TCnMemoryPoolһؼΪܿӻࡣ
*     ֶܳؼڴСͬӦͬһڴͿ(TCnMemoryTypeItem)
*     ؼڴͿ(TCnMemoryTypeItem)еڴ顣ֵȡõֵ
*
TODO >>>
*   1.TCnIocpMemPoolһ:GetFreeMemoryType, ȡһеڴ
*   2.TCnIocpMemPoolڴСǹ̶,ֵÿһη
*   3. TCnIocpSimpleMemPoolװ TCnIocpMemPoolĹ, ڴ͹黹ڴ
*   4.ʹ"""黹"Ϊ"ڴ""ͷڴ"
*   5.TCnIocpSimpleMemPoolӦһڴ, ÿڴ͵ֵ,Զȡ
*   6.Զ(ò):"ڴ""ڴͿ"
*     ÿ TCnIocpSimpleMemPool ӦһڴͿ, ɶ"ڴ".ÿû
*     þǵõһ"ڴ", Сɵһʱȷ.
*     TCnIocpMemPool˶  "ڴͿ", ÿעһʱ,ͷһ"ڴͿ"
TODO >>>
*
* ƽ̨PWin2000Pro + Delphi 7.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   õԪеַϱػʽ
* Ԫʶ$Id: CnIocpSimpleMemPool.pas 1385 2013-12-31 15:39:02Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2008.09.16 V1.0
*                Ԫ
================================================================================
|</PRE>}

interface

{$I CnPack.inc}

uses
  SysUtils, Classes, SyncObjs, Windows, Controls;

const
  SCnErrorNotRegister = 'ûעڴ(%d)!';
  SCnErrorBlockNotRent = 'ڴûб';
  SCnErrorBlockUnknow = 'ûиڴ飡';

type
  TCreateMemoryEvent = procedure(Sender: TObject; var MemoryPtr: Pointer) of object;
  TFreeMemoryEvent = procedure(Sender: TObject; MemoryPtr: Pointer) of object;

  TCnMemoryBlockItem = record
  {* ڴͷ}
    MemoryBlockPtr: Pointer;              //ڴָ
    RentTime: Cardinal;                   //ʱ
    IsRent: Boolean;                      //Ƿ
    RentCount: Cardinal;                  //ô
    Size: Cardinal;
  end;
  PCnMemoryBlockItem = ^TCnMemoryBlockItem;

  TCnMemoryTypeItem = record
  {* ڴͿͷ}
    RefCount: Cardinal;                   //Ϳô
    MemorySize: Cardinal;                 //ڴĴС
    CreateMemoryProc: TCreateMemoryEvent; //ڴ淽ָ
    FreeMemoryProc: TFreeMemoryEvent;     //ͷڴ淽ָ
    Threshold: Cardinal;                  //ڴķֵ
                                          //ĿڸֵҪ
    IdelCount: Cardinal;                  //ڴĸ
    Lock: TCriticalSection;               //
    MemoryBlockList: TList;               //ڴб
  end;
  PCnMemoryTypeItem = ^TCnMemoryTypeItem;

  TCnSimpleMemPoolMgr = class
  private
    FLock: TCriticalSection;
    FMemoryTypeList: TList;

    function RegisterMemoryTypeItem(MemorySize: Cardinal;
                                    CreateMemoryProc: TCreateMemoryEvent;
                                    FreeMemoryProc: TFreeMemoryEvent): PCnMemoryTypeItem;
    {* עڴͿ(߳)}

    procedure UnregisterMemoryTypeItem(MemoryTypeItem: PCnMemoryTypeItem);
    {* עڴͿ}

    function CreateMemoryBlockItem(MemoryTypeItem: PCnMemoryTypeItem): PCnMemoryBlockItem;
    procedure FreeMemoryBlockItem(MemoryTypeItem: PCnMemoryTypeItem;
      MemoryBlockItem: PCnMemoryBlockItem);

    function FindMemoryTypeItem(MemorySize: Cardinal;
                                CreateMemoryProc: TCreateMemoryEvent;
                                FreeMemoryProc: TFreeMemoryEvent): PCnMemoryTypeItem;

    procedure Clear;

  public
    constructor Create;
    destructor Destroy; override;

    function RegisterMemoryType(MemorySize: Cardinal;
                                CreateMemoryProc: TCreateMemoryEvent;
                                FreeMemoryProc: TFreeMemoryEvent): PCnMemoryTypeItem;
    {* עڴͿ :ڴ, ͷŷָ
       ָ¼֪ͨͬʱԶڴͷڴķ}

    procedure UnregisterMemoryType(MemoryTypeItem: PCnMemoryTypeItem);
    {* עڴͿ}
    
    procedure SetThreshold(MemoryTypeItem: PCnMemoryTypeItem; Threshold: Cardinal);
    {* ڴķֵ
      ֵ޵
        ֵʾϵͳеʱ鲻Ҫֵޱʾκʱ򶼲ֵܳ
    }

    procedure RentMemory(MemoryTypeItem: PCnMemoryTypeItem; var MemoryPtr: Pointer);
    {* һڴ}
    procedure ReturnMemory(MemoryTypeItem: PCnMemoryTypeItem; MemoryPtr: Pointer);
    {* һڴ}
  end;

  TCnCustomSimpleMemPool = class (TComponent)
  private
    FMemorySize: Cardinal;
    FThreshold : Cardinal;
    FOnCreateMemory : TCreateMemoryEvent;
    FOnFreeMemory   : TFreeMemoryEvent;
    FMemTypeItem : PCnMemoryTypeItem;
    FIsReg: Boolean;    //ǷѾעᵽڴع

    procedure EnsureRegister;
    procedure DoRegister;
    procedure DoUnregister;

    procedure SetThreshold(const Value: Cardinal);
    procedure SetMemorySize(const Value: Cardinal);
    procedure SetOnCreateMemory(const Value: TCreateMemoryEvent);
    procedure SetOnFreeMemory(const Value: TFreeMemoryEvent);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure RentMemory(var MemoryPtr: Pointer);
    {* ڴ}
    procedure ReturnMemory(MemoryPtr: Pointer);
    {* 黹ڴ}
  public
    property MemorySize: Cardinal read FMemorySize write SetMemorySize;
    {* ڴĴС} 
    property Threshold : Cardinal read FThreshold write SetThreshold;
    {* ڴֵ(ֵ,ɷڴ)}
    property OnCreateMemory : TCreateMemoryEvent read FOnCreateMemory write SetOnCreateMemory;
    {* Զϵͳзڴķ,Ĭʵֲ GetMemory}
    property OnFreeMemory: TFreeMemoryEvent read FOnFreeMemory write SetOnFreeMemory;
    {* Զϵͳͷڴķ,Ĭʵֲ FreeMemory}
  end;

  TCnIocpSimpleMemPool = class(TCnCustomSimpleMemPool)
  published
    property MemorySize;
    {* ڴĴС}
    property Threshold;
    {* ڴֵ(ֵ,ɷڴ)}
    property OnCreateMemory;
    {* Զϵͳзڴķ,Ĭʵֲ GetMemory}
    property OnFreeMemory;
    {* Զϵͳͷڴķ,Ĭʵֲ FreeMemory}
  end;

var
  CnSimpleMemPoolMgr: TCnSimpleMemPoolMgr;

implementation

{ TCnSimpleMemPoolMgr }

constructor TCnSimpleMemPoolMgr.Create;
begin
  FMemoryTypeList := TList.Create;
  FLock := TCriticalSection.Create;
end;

destructor TCnSimpleMemPoolMgr.Destroy;
begin
  Clear;
  FreeAndNil(FMemoryTypeList);
  FreeAndNil(FLock);
  inherited;
end;

procedure TCnSimpleMemPoolMgr.Clear;
var
  TypeItem: PCnMemoryTypeItem;
  I: Integer;
begin
  // ڴ
  FLock.Enter;
  try
    for I := 0 to FMemoryTypeList.Count - 1 do
    begin
      TypeItem := PCnMemoryTypeItem(FMemoryTypeList[I]);
      UnregisterMemoryTypeItem(TypeItem);
    end;
  finally
    FLock.Release;
  end;
end;

function TCnSimpleMemPoolMgr.RegisterMemoryTypeItem(MemorySize: Cardinal;
  CreateMemoryProc: TCreateMemoryEvent; FreeMemoryProc: TFreeMemoryEvent): PCnMemoryTypeItem;
begin
  Result := New(PCnMemoryTypeItem);
  Result^.Lock := TCriticalSection.Create;
  Result^.RefCount := 1;
  Result^.MemorySize := MemorySize;
  Result^.MemoryBlockList := TList.Create;
  Result^.CreateMemoryProc := CreateMemoryProc;
  Result^.FreeMemoryProc := FreeMemoryProc;
  Result^.Threshold := 20;
  Result^.IdelCount := 0;
end;

procedure TCnSimpleMemPoolMgr.UnregisterMemoryTypeItem(MemoryTypeItem: PCnMemoryTypeItem);
var
  I: Integer;
begin
  for I := 0 to MemoryTypeItem^.MemoryBlockList.Count - 1 do
    FreeMemoryBlockItem(MemoryTypeItem, MemoryTypeItem^.MemoryBlockList[I]);
  FreeAndNil(MemoryTypeItem^.Lock);
  FreeAndNil(MemoryTypeItem^.MemoryBlockList);
  Dispose(MemoryTypeItem);
end;

function TCnSimpleMemPoolMgr.CreateMemoryBlockItem(
  MemoryTypeItem: PCnMemoryTypeItem): PCnMemoryBlockItem;
var
  Size: Integer;
begin
  Size := MemoryTypeItem^.MemorySize;
  //ڴ
  Result := New(PCnMemoryBlockItem);
  //ڴ档ûûصʹGetMemoryڴ档
  if (Assigned(MemoryTypeItem.CreateMemoryProc)) then
    MemoryTypeItem^.CreateMemoryProc(Self, Result^.MemoryBlockPtr)
  else
    Result^.MemoryBlockPtr := GetMemory(Size);
  Result^.RentTime := 0;
  Result^.IsRent := False;
  Result^.RentCount := 0;
  Result^.Size := Size;
end;

procedure TCnSimpleMemPoolMgr.FreeMemoryBlockItem(MemoryTypeItem: PCnMemoryTypeItem;
  MemoryBlockItem: PCnMemoryBlockItem);
begin
  //ͷڴ
  if (Assigned(MemoryTypeItem.FreeMemoryProc)) then
    MemoryTypeItem.FreeMemoryProc(Self, MemoryBlockItem^.MemoryBlockPtr)
  else
    FreeMemory(MemoryBlockItem^.MemoryBlockPtr);
  //ͷڴ
  Dispose(MemoryBlockItem);
end;

function TCnSimpleMemPoolMgr.FindMemoryTypeItem(MemorySize: Cardinal;
  CreateMemoryProc: TCreateMemoryEvent; FreeMemoryProc: TFreeMemoryEvent): PCnMemoryTypeItem;
var
  I: Integer;
begin
  FLock.Enter;
  try
    for I := 0 to FMemoryTypeList.Count - 1 do
    begin       
      Result := PCnMemoryTypeItem(FMemoryTypeList[I]);
      if (Result^.MemorySize = MemorySize) and
        (@Result^.CreateMemoryProc = @CreateMemoryProc) and
        (@Result^.FreeMemoryProc = @FreeMemoryProc) then Exit;
    end;
    Result := nil;
  finally
    FLock.Release;
  end;
end;

function TCnSimpleMemPoolMgr.RegisterMemoryType(MemorySize: Cardinal;
  CreateMemoryProc: TCreateMemoryEvent; FreeMemoryProc: TFreeMemoryEvent): PCnMemoryTypeItem;
begin
  Result := FindMemoryTypeItem(MemorySize, CreateMemoryProc, FreeMemoryProc);
  if Result = nil then                      //,ʹ
  begin
    Result := RegisterMemoryTypeItem(MemorySize, CreateMemoryProc, FreeMemoryProc);
    FLock.Enter;
    try
      FMemoryTypeList.Add(Result);            //List
    finally
      FLock.Release;  
    end;
  end else
  begin
    Inc(Result^.RefCount);                  //ü
  end;
end;

procedure TCnSimpleMemPoolMgr.UnregisterMemoryType(MemoryTypeItem: PCnMemoryTypeItem);
begin
  //ü
  Dec(MemoryTypeItem^.RefCount);
  if MemoryTypeItem^.RefCount <> 0 then Exit;

  FLock.Enter;
  try
    FMemoryTypeList.Remove(MemoryTypeItem);
  finally
    FLock.Release;
  end;
  UnregisterMemoryTypeItem(MemoryTypeItem);
end;

procedure TCnSimpleMemPoolMgr.SetThreshold(MemoryTypeItem: PCnMemoryTypeItem; Threshold: Cardinal);
begin
  //һMemoryTypeItemжãʹķֵ
  if MemoryTypeItem <> nil then
  begin
    if MemoryTypeItem^.RefCount = 1 then
      MemoryTypeItem^.Threshold := Threshold
    else
      if MemoryTypeItem^.Threshold < Threshold then
        MemoryTypeItem^.Threshold := Threshold;
  end;
end;

procedure TCnSimpleMemPoolMgr.RentMemory(MemoryTypeItem: PCnMemoryTypeItem; var MemoryPtr: Pointer);
var
  BlockItem: PCnMemoryBlockItem;
begin
  //ҪѭңֻҪҵһڴ飬ʾڴ鶼Ѿˡ
  MemoryTypeItem^.Lock.Enter;
  try
    if MemoryTypeItem^.MemoryBlockList.Count > 0 then
    begin
      BlockItem := PCnMemoryBlockItem(MemoryTypeItem^.MemoryBlockList[0]);
      if not BlockItem^.IsRent then      //0ڴǷ
      begin
        MemoryTypeItem^.MemoryBlockList.Remove(BlockItem);
        MemoryTypeItem^.MemoryBlockList.Add(BlockItem);  //ڴ·뵽LIST
        MemoryPtr := BlockItem.MemoryBlockPtr;     //ȡڴָ
        Inc(BlockItem^.RentCount);                 //+1
        BlockItem^.RentTime := GetTickCount;       //ʱ
        BlockItem^.IsRent := True;                 //ñ־

        //ڴһ
        Dec(MemoryTypeItem^.IdelCount);

        Exit;
      end;
    end;

    // ´һڴ
    BlockItem := CreateMemoryBlockItem(MemoryTypeItem);
    MemoryPtr := BlockItem^.MemoryBlockPtr;
    Inc(BlockItem^.RentCount);
    BlockItem^.RentTime := GetTickCount;
    BlockItem^.IsRent := True;
    BlockItem^.Size := MemoryTypeItem^.MemorySize;
    MemoryTypeItem^.MemoryBlockList.Add(BlockItem);
  finally
    MemoryTypeItem^.Lock.Release;
  end;
end;

procedure TCnSimpleMemPoolMgr.ReturnMemory(MemoryTypeItem: PCnMemoryTypeItem; MemoryPtr: Pointer);
var
  I: Integer;
  BlockItem: PCnMemoryBlockItem;
  ReleaseCount: Cardinal;
  UsedCount: Cardinal;
  TotalCount: Cardinal;
begin
  //ڴĵǿԵģԭڷʱһڿĸ
  MemoryTypeItem^.Lock.Enter;
  try
    ReleaseCount := 0;
    //жǷҪɾڴ
    TotalCount := MemoryTypeItem^.MemoryBlockList.Count;
    if TotalCount > MemoryTypeItem^.Threshold then
    begin
      UsedCount := TotalCount - MemoryTypeItem^.IdelCount;
      if UsedCount < MemoryTypeItem^.Threshold then
      begin
        //Ҫɾڴĸ
        //ʾһҪɾôڴ飬»ɾôڴ
        ReleaseCount := TotalCount - MemoryTypeItem^.Threshold;
      end;
    end;
    
    for I := MemoryTypeItem^.MemoryBlockList.Count - 1 downto 0 do
    begin
      BlockItem := PCnMemoryBlockItem(MemoryTypeItem^.MemoryBlockList[I]);
      if MemoryPtr = BlockItem^.MemoryBlockPtr then         //ѯڴ(Ƚϵַͬ)
      begin
        if BlockItem^.IsRent then
        begin
          //黹ڴ
          BlockItem^.RentTime := 0;
          BlockItem^.IsRent := False;
          MemoryTypeItem^.MemoryBlockList.Remove(BlockItem);
          MemoryTypeItem^.MemoryBlockList.Insert(0, BlockItem);  //뵽0
          //ڴһ
          Inc(MemoryTypeItem^.IdelCount);
          Exit;
        end 
        else
          raise Exception.Create(SCnErrorBlockNotRent); //ûб쳣 
      end;
      //ͷڴ
      if (ReleaseCount <> 0) and (not BlockItem^.IsRent) then
      begin
        FreeMemoryBlockItem(MemoryTypeItem, BlockItem);
        MemoryTypeItem^.MemoryBlockList.Remove(BlockItem);
        Dec(ReleaseCount);
      end;
    end;
    raise Exception.Create(SCnErrorBlockUnknow);        //ûҵڴ׳쳣
  finally
    MemoryTypeItem^.Lock.Release;
  end;
end;

{ TCnIocpSimpleMemPool }

constructor TCnCustomSimpleMemPool.Create(AOwner: TComponent);
begin
  inherited;
  FThreshold := 20;
  FMemorySize := 1024;
  FIsReg := False;
  //ʹӳע᷽ʽʼɷע
  //DoRegister;
end;

destructor TCnCustomSimpleMemPool.Destroy;
begin
  DoUnregister;
  inherited;
end;

procedure TCnCustomSimpleMemPool.EnsureRegister;
begin
  if not FIsReg then
    DoRegister;
end;

procedure TCnCustomSimpleMemPool.DoRegister;
begin
  if (not (csDesigning in ComponentState)) and (not FIsReg) then
  begin
    FMemTypeItem := CnSimpleMemPoolMgr.RegisterMemoryType(
      FMemorySize, FOnCreateMemory, FOnFreeMemory);
    CnSimpleMemPoolMgr.SetThreshold(FMemTypeItem, Threshold);
    FIsReg := True;
  end;
end;

procedure TCnCustomSimpleMemPool.DoUnregister;
begin
  if FIsReg then
  begin
    CnSimpleMemPoolMgr.UnregisterMemoryType(FMemTypeItem);
    FIsReg := False;
  end;
end;

procedure TCnCustomSimpleMemPool.RentMemory(var MemoryPtr: Pointer);
begin
  EnsureRegister;
  
  CnSimpleMemPoolMgr.RentMemory(FMemTypeItem, MemoryPtr);
end;

procedure TCnCustomSimpleMemPool.ReturnMemory(MemoryPtr: Pointer);
begin
  EnsureRegister;
  
  CnSimpleMemPoolMgr.ReturnMemory(FMemTypeItem, MemoryPtr);
end;

procedure TCnCustomSimpleMemPool.SetMemorySize(const Value: Cardinal);
begin
  if FMemorySize <> Value then
  begin
    if FIsReg then DoUnregister;

    FMemorySize := Value;
  end;
end;

procedure TCnCustomSimpleMemPool.SetThreshold(const Value: Cardinal);
begin
  if FThreshold <> Value then
  begin
    FThreshold := Value;
    if FIsReg then
      CnSimpleMemPoolMgr.SetThreshold(FMemTypeItem, FThreshold);
  end;
end;

procedure TCnCustomSimpleMemPool.SetOnCreateMemory(const Value: TCreateMemoryEvent);
begin
  if @FOnCreateMemory <> @Value then
  begin
    if FIsReg then DoUnregister;

    FOnCreateMemory := Value;
  end;
end;

procedure TCnCustomSimpleMemPool.SetOnFreeMemory(const Value: TFreeMemoryEvent);
begin
  if @FOnFreeMemory <> @Value then
  begin
    if FIsReg then DoUnregister;

    FOnFreeMemory := Value;
  end;
end;

initialization
  CnSimpleMemPoolMgr := TCnSimpleMemPoolMgr.Create;

finalization
  CnSimpleMemPoolMgr.Free;

end.
