{******************************************************************************}
{                       CnPack For Delphi/C++Builder                           }
{                     йԼĿԴ                         }
{                   (C)Copyright 2001-2014 CnPack                        }
{                   ------------------------------------                       }
{                                                                              }
{            ǿԴ CnPack ķЭ        }
{        ĺ·һ                                                }
{                                                                              }
{            һĿϣãûκεû        }
{        ʺضĿĶĵϸ CnPack Э顣        }
{                                                                              }
{            ӦѾͿһյһ CnPack Эĸ        }
{        ûУɷǵվ                                            }
{                                                                              }
{            վַhttp://www.cnpack.org                                   }
{            ʼmaster@cnpack.org                                       }
{                                                                              }
{******************************************************************************}

{******************************************************************************}
{ Unit Note:                                                                   }
{    This file is derived from GExperts 1.2                                    }
{                                                                              }
{ Original author:                                                             }
{    GExperts, Inc  http://www.gexperts.org/                                   }
{    Erik Berry <eberry@gexperts.org> or <eb@techie.com>                       }
{******************************************************************************}

unit CnWizIdeDock;
{* |<PRE>
================================================================================
* ƣCnPack IDE רҰ
* ԪƣIDE Dock 嵥Ԫ
* Ԫߣܾ (zjy@cnpack.org)
*     עôΪ֧ IDE ڲͣĻ壬ֲ GExperts
*           ԭʼ GExperts License ı
* ƽ̨PWin2000Pro + Delphi 5.01
* ݲԣPWin9X/2000/XP + Delphi 5/6/7 + C++Builder 5/6
*   ôеַϱػʽ
* Ԫʶ$Id: CnWizIdeDock.pas 1385 2013-12-31 15:39:02Z liuxiaoshanzhashu@gmail.com $
* ޸ļ¼2012.11.30
*               ʹCnFormScaler壬ù̶96/72ߴ㡣
*           2009.01.07
*               λñ湦ܣһЩ CnTranslateForm вͬĻ
*           2004.11.19 V1.1
*               лScaled=Falseʱ廹ǻScaledBUG (shenloqi)
*           2003.02.16 V1.0
*                GExperts 1.12Src ޸Ķ
================================================================================
|</PRE>}

interface

{$I CnWizards.inc}

{$IFDEF COMPILER12}
// RAD Studio 2009  CreateParams пܵѭ
{$DEFINE CREATE_PARAMS_BUG}
{$ENDIF}

uses
  Windows, SysUtils, Classes, IniFiles, Forms, Controls, Menus, Messages,
  MenuBar, ActnList, CnWizUtils, CnClasses, CnLangMgr, CnFormScaler,
  CnLangCollection, CnLangStorage,
  // õԪ DsnIdeXX/DesignIde Уרұ
  DockForm;

type

{ TDummyPopupMenu }

  TDummyPopupMenu = class(TPopupMenu)
  private
    OwnerMenu: TMenu;
  public
    function IsShortCut(var Message: TWMKey): Boolean; override;
  end;

{ TCnIdeDockForm }

{$IFDEF COMPILER8_UP}
  TDesktopIniFile = TCustomIniFile;
{$ELSE}
  TDesktopIniFile = TMemIniFile;
{$ENDIF}

  TCnIdeDockForm = class(TDockableForm)
  protected
    FMenuBar: TMenuBar;
    FNeedRestore: Boolean;
    FRestoreRect: TRect;
    // ¸ TCnTranslateForm ʵֶ
    FScaler: TCnFormScaler;
    procedure OnLanguageChanged(Sender: TObject);
    procedure OnHelp(Sender: TObject);
    function DoHandleShortCut(var Message: TWMKey): Boolean;
    procedure RestorePosition;
    procedure CheckDefaultFontSize();
  protected
    procedure Loaded; override;
    procedure DoShow; override;

    // ¸ TCnTranslateForm ʵֶ
    procedure DoCreate; override;
    procedure DoDestroy; override;
    procedure ReadState(Reader: TReader); override;

{$IFDEF CREATE_PARAMS_BUG}
    procedure CreateParams(var Params: TCreateParams); override;
{$ENDIF}

    function HandleShortCut(AShortCut: TShortCut): Boolean; virtual;
    {* ݼ}
    procedure DoLoadWindowState(Desktop: TCustomIniFile); virtual;
    {* װò}
    procedure DoSaveWindowState(Desktop: TCustomIniFile; IsProject: Boolean); virtual;
    {* ò}
    procedure DoLanguageChanged(Sender: TObject); virtual;
    {* ǰԱ֪ͨ}
    function GetHelpTopic: string; virtual;
    {* രش˷ F1 Ӧİ}
    function GetNeedPersistentPosition: Boolean; virtual;
    {* രش˷ǷҪ洰Сλù´ָ
        Dock 壬ĬҪ }
    procedure ShowFormHelp;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure DefaultHandler(var Message); override;
    procedure LoadWindowState(Desktop: TDesktopIniFile); override;
    procedure SaveWindowState(Desktop: TDesktopIniFile; IsProject: Boolean); override;

    // ¸ TCnTranslateForm ʵֶ
    procedure Translate; virtual;
  end;

type
  TIdeDockFormClass = class of TCnIdeDockForm;

type
  EIdeDockError = class(Exception);

  IIdeDockManager = interface(IUnknown)
    ['{408FC1B1-BD7A-4401-93C2-B41E1D19580B}']
    // Note: IdeDockFormName must be IDE-unique
    procedure RegisterDockableForm(IdeDockFormClass: TIdeDockFormClass;
      var IdeDockFormVar; const IdeDockFormName: string);
    procedure UnRegisterDockableForm(
      var IdeDockFormVar; const IdeDockFormName: string);

    procedure ShowForm(Form: TForm);
  end;

function IdeDockManager: IIdeDockManager;

implementation

uses
{$IFDEF DEBUG}
  CnDebug,
{$ENDIF}
  CnCommon, CnWizConsts, CnWizOptions, CnWizNotifier,
  // µԪ DsnIdeXX/DesignIde Уרұ
  DeskForm, DeskUtil;

{$R *.dfm}

type
  TIdeDockManager = class(TSingletonInterfacedObject, IIdeDockManager)
  public
    // Note: IdeDockFormName must be IDE-unique
    procedure RegisterDockableForm(IdeDockFormClass: TIdeDockFormClass;
      var IdeDockFormVar; const IdeDockFormName: string);
    procedure UnRegisterDockableForm(
      var IdeDockFormVar; const IdeDockFormName: string);
    procedure ShowForm(Form: TForm);
  end;

const
  csFixPPI = 96;
  csFixPerInch = 72;

var
  FDefaultFontSize: Integer = 8;

{ TIdeDockManager }

procedure TIdeDockManager.ShowForm(Form: TForm);
begin
  with Form as TDockableForm do
  begin
    if not Floating then
    begin
      ForceShow;
      FocusWindow(Form);
    end
    else
      Show;
  end;
end;

procedure TIdeDockManager.RegisterDockableForm(IdeDockFormClass: TIdeDockFormClass;
  var IdeDockFormVar; const IdeDockFormName: string);
begin
  if @RegisterFieldAddress <> nil then
    RegisterFieldAddress(IdeDockFormName, @IdeDockFormVar);

  RegisterDesktopFormClass(IdeDockFormClass, IdeDockFormName, IdeDockFormName);
end;

procedure TIdeDockManager.UnRegisterDockableForm(var IdeDockFormVar; const
  IdeDockFormName: string);
begin
  if @UnregisterFieldAddress <> nil then
    UnregisterFieldAddress(@IdeDockFormVar);
end;

var
  PrivateIdeDockManager: TIdeDockManager = nil;

function IdeDockManager: IIdeDockManager;
begin
  Result := PrivateIdeDockManager as IIdeDockManager;
end;

{ TCnIdeDockForm }

constructor TCnIdeDockForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  if PopupMenu = nil then
  begin
    PopupMenu := TDummyPopupMenu.Create(Self);
    PopupMenu.AutoPopup := False;
    TDummyPopupMenu(PopupMenu).OwnerMenu := Menu;
  end;

  if Menu <> nil then
  begin
    FMenuBar := TMenuBar.Create(Self);
    FMenuBar.Parent := Self;
    FMenuBar.Menu := Menu;
    FMenuBar.Height := GetSystemMetrics(SM_CYMENU) + 2;
    Menu := nil;
  end;
  DeskSection := Name;
  AutoSave := True;
  SaveStateNecessary := True;
end;

destructor TCnIdeDockForm.Destroy;
begin
  SaveStateNecessary := True;
  inherited Destroy;
end;

procedure TCnIdeDockForm.Loaded;
var
  Ini: TCustomIniFile;
  I: Integer;
begin
  inherited Loaded;
  FScaler := TCnFormScaler.Create(Self);
  FScaler.DoEffects;

  // ȡָλã IDE ͣ Form £ƺЧ
  if GetNeedPersistentPosition then
  begin
    Ini := WizOptions.CreateRegIniFile;
    try
      FNeedRestore := True;
      I := Ini.ReadInteger(SCnFormPosition, ClassName + SCnFormPositionTop, -1);
      if I <> -1 then FRestoreRect.Top := I else FNeedRestore := False;
      I := Ini.ReadInteger(SCnFormPosition, ClassName + SCnFormPositionLeft, -1);
      if I <> -1 then FRestoreRect.Left := I else FNeedRestore := False;
      I := Ini.ReadInteger(SCnFormPosition, ClassName + SCnFormPositionWidth, -1);
      if I <> -1 then FRestoreRect.Right := I + FRestoreRect.Left else FNeedRestore := False;
      I := Ini.ReadInteger(SCnFormPosition, ClassName + SCnFormPositionHeight, -1);
      if I <> -1 then FRestoreRect.Bottom := I + FRestoreRect.Top else FNeedRestore := False;;

      Position := poDesigned;
    finally
      Ini.Free;
    end;
  end;
end;

procedure TCnIdeDockForm.DoCreate;
begin
  DisableAlign;
  try
    Translate;
    if not Scaled then
    begin
      CheckDefaultFontSize;
      Font.Height := -MulDiv(FDefaultFontSize, csFixPPI, csFixPerInch);
    end;
  finally
    EnableAlign;
  end;
  DoLanguageChanged(CnLanguageManager);

  inherited;
end;

procedure TCnIdeDockForm.DoDestroy;
var
  Ini: TCustomIniFile;
begin
  // λãͣ
  if (Parent = nil) and GetNeedPersistentPosition and (Position in [poDesigned,
    poDefault, poDefaultPosOnly, poDefaultSizeOnly]) then
  begin
    Ini := WizOptions.CreateRegIniFile;
    try
      Ini.WriteInteger(SCnFormPosition, ClassName + SCnFormPositionTop, Top);
      Ini.WriteInteger(SCnFormPosition, ClassName + SCnFormPositionLeft, Left);
      Ini.WriteInteger(SCnFormPosition, ClassName + SCnFormPositionWidth, Width);
      Ini.WriteInteger(SCnFormPosition, ClassName + SCnFormPositionHeight, Height);
    finally
      Ini.Free;
    end;
  end;

  FScaler.Free;
  if CnLanguageManager <> nil then
    CnLanguageManager.RemoveChangeNotifier(OnLanguageChanged);
  inherited;
end;

procedure TCnIdeDockForm.ReadState(Reader: TReader);
begin
  inherited;
  OldCreateOrder := False;
end;

{$IFDEF CREATE_PARAMS_BUG}

procedure TCnIdeDockForm.CreateParams(var Params: TCreateParams);
var
  OldLong: Longint;
  AHandle: THandle;
  NeedChange: Boolean;
begin
  NeedChange := False;
  OldLong := 0;
  AHandle := Application.ActiveFormHandle;
  if AHandle <> 0 then
  begin
    OldLong := GetWindowLong(AHandle, GWL_EXSTYLE);
    NeedChange := OldLong and WS_EX_TOOLWINDOW = WS_EX_TOOLWINDOW;
    if NeedChange then
    begin
{$IFDEF DEBUG}
      CnDebugger.LogMsg('TCnIdeDockForm: D2009 Bug fix: HWnd for WS_EX_TOOLWINDOW style.');
{$ENDIF}
      SetWindowLong(AHandle, GWL_EXSTYLE, OldLong and not WS_EX_TOOLWINDOW);
    end;
  end;

  inherited; // ȴ굱ǰڵķԭָ̣֮

  if NeedChange and (OldLong <> 0) then
    SetWindowLong(AHandle, GWL_EXSTYLE, OldLong);
end;

{$ENDIF}

procedure TCnIdeDockForm.LoadWindowState(Desktop: TDesktopIniFile);
begin
  inherited LoadWindowState(Desktop);
  DoLoadWindowState(Desktop);
end;

procedure TCnIdeDockForm.SaveWindowState(Desktop: TDesktopIniFile; IsProject: Boolean);
begin
  inherited SaveWindowState(Desktop, IsProject);
  DoSaveWindowState(Desktop, IsProject);
end;

procedure TCnIdeDockForm.DoLoadWindowState(Desktop: TCustomIniFile);
begin

end;

procedure TCnIdeDockForm.DoSaveWindowState(Desktop: TCustomIniFile; IsProject: Boolean);
begin

end;

procedure TCnIdeDockForm.DefaultHandler(var Message);
begin
  // ͣʱøؼĲ˵
  if TMessage(Message).Msg <> WM_CONTEXTMENU then
    inherited;
end;

procedure TCnIdeDockForm.Translate;
begin
  if (CnLanguageManager <> nil) and (CnLanguageManager.LanguageStorage <> nil)
    and (CnLanguageManager.LanguageStorage.LanguageCount > 0) then
  begin
    CnLanguageManager.AddChangeNotifier(OnLanguageChanged);
    Screen.Cursor := crHourGlass;
    try
      CnLanguageManager.TranslateForm(Self);
    finally
      Screen.Cursor := crDefault;
    end;
  end
  else
  begin
{$IFDEF DEBUG}
    CnDebugger.LogMsgError('MultiLang Initialization Error. Use English Font as default.');
{$ENDIF}
    // ʼʧܶĿԭʼӢģΪӢ
    Font.Charset := DEFAULT_CHARSET;
  end;
end;

procedure TCnIdeDockForm.CheckDefaultFontSize;
var
  Storage: TCnCustomLangStorage;
  Language: TCnLanguageItem;
begin
  Storage := CnLanguageManager.LanguageStorage;
  Language := nil;
  if Storage <> nil then
  begin
    Language := Storage.CurrentLanguage;
    if Storage.FontInited and (Storage.DefaultFont <> nil) then
      FDefaultFontSize := Storage.DefaultFont.Size;
  end;

  if (Language <> nil) and (Language.DefaultFont <> nil) then
    FDefaultFontSize := Language.DefaultFont.Size;

{$IFDEF DEBUG}
  CnDebugger.LogMsg('TCnIdeDockForm.CheckDefaultFontSize. Get Default Font Size: ' + IntToStr(FDefaultFontSize));
{$ENDIF}        
end;

procedure TCnIdeDockForm.OnLanguageChanged(Sender: TObject);
begin
  DisableAlign;
  try
    CnLanguageManager.TranslateForm(Self);
    if not Scaled then
    begin
      CheckDefaultFontSize;
      Font.Height := -MulDiv(FDefaultFontSize, csFixPPI, csFixPerInch);
    end;
  finally
    EnableAlign;
  end;
  DoLanguageChanged(Sender);
end;

procedure TCnIdeDockForm.ShowFormHelp;
begin
  OnHelp(nil)
end;

procedure TCnIdeDockForm.OnHelp(Sender: TObject);
var
  Topic: string;
begin
  Topic := GetHelpTopic;
  if Topic <> '' then
    ShowHelp(Topic);
end;

function TCnIdeDockForm.DoHandleShortCut(var Message: TWMKey): Boolean;
var
  AShortCut: TShortCut;
  ShiftState: TShiftState;
begin
  ShiftState := KeyDataToShiftState(Message.KeyData);
  AShortCut := ShortCut(Message.CharCode, ShiftState);
  Result := HandleShortCut(AShortCut);
end;

function TCnIdeDockForm.HandleShortCut(AShortCut: TShortCut): Boolean;
begin
  if AShortCut = ShortCut(VK_F1, []) then
  begin
    ShowFormHelp;
    Result := True;
  end
  else
    Result := HandleEditShortCut(Screen.ActiveControl, AShortCut);
end;

function TCnIdeDockForm.GetHelpTopic: string;
begin
  Result := '';
end;

procedure TCnIdeDockForm.DoLanguageChanged(Sender: TObject);
begin
  // Ҳɶ
end;

function TCnIdeDockForm.GetNeedPersistentPosition: Boolean;
begin
  Result := True; //  IDEDockFormΪ True;
end;

procedure TCnIdeDockForm.DoShow;
begin
  if FNeedRestore and (Parent = nil) then
  begin
    RestorePosition;
    FNeedRestore := False;
  end;
  inherited;
end;

procedure TCnIdeDockForm.RestorePosition;
begin
  SetBounds(FRestoreRect.Left, FRestoreRect.Top,
    FRestoreRect.Right - FRestoreRect.Left, FRestoreRect.Bottom - FRestoreRect.Top);
end;

{ TDummyPopupMenu }

function TDummyPopupMenu.IsShortCut(var Message: TWMKey): Boolean;
begin
  // Call the form's IsShortCut so docked forms can use main menu shortcuts
  Result := (OwnerMenu <> nil) and OwnerMenu.IsShortCut(Message) or
    TCustomForm(Owner).IsShortCut(Message) or
    TCnIdeDockForm(Owner).DoHandleShortCut(Message);
end;

initialization
  PrivateIdeDockManager := TIdeDockManager.Create;

finalization
  FreeAndNil(PrivateIdeDockManager);

end.

